/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.menu;

import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class FilteredSlot
extends Slot {
    private final Consumer<SlotChangedArgs> onItemChanged;
    private final int maxStackSize;
    private final int slot;
    private final Predicate<ItemStack> mayPlacePredicate;

    public FilteredSlot(Container container, int slot, int x, int y, int maxStackSize, Consumer<SlotChangedArgs> onItemChanged, Predicate<ItemStack> mayPlacePredicate) {
        super(container, slot, x, y);
        Preconditions.checkArgument((maxStackSize > 0 && maxStackSize <= 64 ? 1 : 0) != 0, (Object)(maxStackSize + " is not valid. (1-64)"));
        this.slot = slot;
        this.maxStackSize = maxStackSize;
        this.onItemChanged = onItemChanged;
        this.mayPlacePredicate = mayPlacePredicate;
    }

    public int getSlotId() {
        return this.slot;
    }

    public int m_6641_() {
        return Math.min(this.f_40218_.m_6893_(), this.maxStackSize);
    }

    public boolean m_5857_(ItemStack stack) {
        return this.mayPlacePredicate.test(stack);
    }

    public void m_5852_(ItemStack stack) {
        ItemStack oldStack = this.m_7993_().m_41777_();
        super.m_5852_(stack);
        this.onItemChanged.accept(new SlotChangedArgs(this, oldStack, this.m_7993_()));
    }

    @NotNull
    public ItemStack m_6201_(int amount) {
        ItemStack oldStack = this.m_7993_().m_41777_();
        ItemStack removed = super.m_6201_(amount);
        ItemStack newStack = this.m_7993_();
        this.onItemChanged.accept(new SlotChangedArgs(this, oldStack, newStack));
        return removed;
    }

    public record SlotChangedArgs(FilteredSlot slot, ItemStack oldStack, ItemStack newStack) {
    }
}

